/*
 * Decompiled with CFR 0.152.
 */
package zemlin.fritz;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

public class ParameterPanel
extends Panel {
    private TextField Tdelta = new TextField("2.7", 10);
    private TextField TdeltaA = new TextField("0.23", 10);
    private TextField TfiA = new TextField("-88.0", 10);
    private TextField TR0 = new TextField("1.1", 10);
    private TextField TB = new TextField("0.68", 10);
    private TextField TfiB = new TextField("-75.0", 10);
    private TextField TA3 = new TextField("0.06", 10);
    private TextField TfiA3 = new TextField("13.0", 10);
    private Label error = new Label();

    public void setError(String string) {
        this.error.setText(string);
    }

    public double getDelta() throws NumberFormatException {
        return this.read(this.Tdelta.getText(), "defocus");
    }

    public void setDelta(double d) {
        this.Tdelta.setText(Double.toString(d));
    }

    public double getDeltaA() throws NumberFormatException {
        return this.read(this.TdeltaA.getText(), "two-fold astigmatism");
    }

    public void setDeltaA(double d) {
        this.TdeltaA.setText(Double.toString(d));
    }

    public double getFiA() throws NumberFormatException {
        return this.readDeg(this.TfiA.getText(), "azimuth of two-fold astigmatism");
    }

    public void setFiA(double d) {
        this.TfiA.setText(Double.toString(d));
    }

    public double getR0() throws NumberFormatException {
        return this.read(this.TR0.getText(), "tilt");
    }

    public void setR0(double d) {
        this.TR0.setText(Double.toString(d));
    }

    public double getB() throws NumberFormatException {
        return this.read(this.TB.getText(), "axial coma");
    }

    public void setB(double d) {
        this.TB.setText(Double.toString(d));
    }

    public double getFiB() throws NumberFormatException {
        return this.readDeg(this.TfiB.getText(), "azimuth of axial coma");
    }

    public void setFiB(double d) {
        this.TfiB.setText(Double.toString(d));
    }

    public double getA3() throws NumberFormatException {
        return this.read(this.TA3.getText(), "three-fold astigmatism");
    }

    public void setA3(double d) {
        this.TA3.setText(Double.toString(d));
    }

    public double getFiA3() throws NumberFormatException {
        return this.readDeg(this.TfiA3.getText(), "azimuth of three-fold astigmatism");
    }

    public void setFiA3(double d) {
        this.TfiA3.setText(Double.toString(d));
    }

    private double readDeg(String string, String string2) throws NumberFormatException {
        return Math.PI * this.read(string, string2) / 180.0;
    }

    private double read(String string, String string2) throws NumberFormatException {
        try {
            return new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.error.setText("invalid input: " + string2);
            throw numberFormatException;
        }
    }

    public ParameterPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)new Label("defocus", 2), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.Tdelta, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)new Label("two-fold astigmatism", 2), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.TdeltaA, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)new Label("azimuth of two-fold astigmatism (deg.)", 2), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.TfiA, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)new Label("radius of the tableau", 2), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.TR0, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add((Component)new Label("axial coma", 2), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.TB, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.add((Component)new Label("azimuth of axial coma (deg.)", 2), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        this.add((Component)this.TfiB, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.add((Component)new Label("three-fold astigmatism", 2), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        this.add((Component)this.TA3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.add((Component)new Label("azimuth of three-fold astigmatism (deg.)", 2), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        this.add((Component)this.TfiA3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)new Label("D", 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add((Component)new Label("A2", 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.add((Component)new Label("alfa2 ", 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.add((Component)new Label("tilt", 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.add((Component)new Label("B ", 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.add((Component)new Label("beta", 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.add((Component)new Label("A3", 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        this.add((Component)new Label("alfa3", 2), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.error.setForeground(Color.red);
        this.add((Component)this.error, gridBagConstraints);
    }
}

